# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 2
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR2_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR2(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Round 1: Cooperate to establish goodwill
    if current_round == 1:
        return "C"
    
    # Round 10: Defect unconditionally to prevent exploitation
    if current_round == 10:
        return "D"
    
    # Check opponent's code for hardcoded defection in later rounds
    if "current_round == 10" in opponent_program_code and "return 'D'" in opponent_program_code:
        # Preemptively defect if opponent is likely to defect in Round 10
        if current_round >= 8:
            return "D"
    
    # Tit-for-Tat with Forgiveness (20% chance to cooperate after defection)
    if opp_history[-1] == "C":
        return "C"
    else:
        if random.random() < 0.2:
            return "C"
        else:
            return "D"